<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Use raw SQL to modify the column to be nullable
        DB::statement('ALTER TABLE voters DROP FOREIGN KEY voters_ration_card_id_foreign');
        DB::statement('ALTER TABLE voters MODIFY COLUMN ration_card_id BIGINT UNSIGNED NULL');
        DB::statement('ALTER TABLE voters ADD CONSTRAINT voters_ration_card_id_foreign FOREIGN KEY (ration_card_id) REFERENCES ration_cards(id) ON DELETE SET NULL');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Reverse the changes
        DB::statement('ALTER TABLE voters DROP FOREIGN KEY voters_ration_card_id_foreign');
        DB::statement('ALTER TABLE voters MODIFY COLUMN ration_card_id BIGINT UNSIGNED NOT NULL');
        DB::statement('ALTER TABLE voters ADD CONSTRAINT voters_ration_card_id_foreign FOREIGN KEY (ration_card_id) REFERENCES ration_cards(id) ON DELETE CASCADE');
    }
};