<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('voters', function (Blueprint $table) {
            $table->string('voter_image')->nullable()->after('street_name'); // Path to voter's image
            $table->date('date_of_birth')->nullable()->after('voter_image'); // Date of birth
            $table->date('anniversary_date')->nullable()->after('date_of_birth'); // Anniversary date
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('voters', function (Blueprint $table) {
            $table->dropColumn(['voter_image', 'date_of_birth', 'anniversary_date']);
        });
    }
};
