<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('voters', function (Blueprint $table) {
            $table->unsignedBigInteger('street_id')->nullable()->after('aadhar_number');
            $table->string('street_name')->nullable()->after('street_id');
            
            // Add foreign key constraint to streets table
            $table->foreign('street_id')->references('id')->on('streets')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('voters', function (Blueprint $table) {
            $table->dropForeign(['street_id']);
            $table->dropColumn(['street_id', 'street_name']);
        });
    }
};
