<?php

return [
    
    /*
    |--------------------------------------------------------------------------
    | Export Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration for handling large data exports
    | Optimized for datasets with 40k+ records
    |
    */

    'chunk_size' => [
        'excel' => env('EXPORT_EXCEL_CHUNK_SIZE', 1000),
        'csv' => env('EXPORT_CSV_CHUNK_SIZE', 2000),
    ],

    'memory_limit' => [
        'excel' => env('EXPORT_EXCEL_MEMORY_LIMIT', '256M'),
        'csv' => env('EXPORT_CSV_MEMORY_LIMIT', '128M'),
    ],

    'execution_time' => [
        'excel' => env('EXPORT_EXCEL_TIME_LIMIT', 600), // 10 minutes
        'csv' => env('EXPORT_CSV_TIME_LIMIT', 300),     // 5 minutes
    ],

    /*
    |--------------------------------------------------------------------------
    | Export Thresholds
    |--------------------------------------------------------------------------
    |
    | Define when to recommend different export formats based on record count
    |
    */
    
    'thresholds' => [
        'recommend_csv_over_excel' => 50000,  // Recommend CSV for 50k+ records
        'enable_chunking' => 5000,            // Enable chunking for 5k+ records
        'show_progress' => 10000,             // Show progress for 10k+ records
    ],

    /*
    |--------------------------------------------------------------------------
    | File Settings
    |--------------------------------------------------------------------------
    */

    'temp_directory' => env('EXPORT_TEMP_DIR', sys_get_temp_dir()),
    'cleanup_after_download' => true,
    
    /*
    |--------------------------------------------------------------------------
    | Progress Tracking
    |--------------------------------------------------------------------------
    */

    'progress' => [
        'enabled' => env('EXPORT_PROGRESS_ENABLED', true),
        'cache_prefix' => 'export_progress_',
        'cache_ttl' => 3600, // 1 hour
    ],

];