<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Grievance extends Model
{
    use HasFactory;

    protected $fillable = [
        'voter_id',
        'ration_card_number',
        'title',
        'description',
        'status',
        'meeting_date',
        'reported_at',
        'target_resolve_by',
        'closed_at',
    ];

    protected $casts = [
        'meeting_date' => 'date',
        'reported_at' => 'datetime',
        'target_resolve_by' => 'date',
        'closed_at' => 'datetime',
    ];

    // Define available status values
    public const STATUS_OPEN = 'OPEN';
    public const STATUS_IN_PROGRESS = 'IN_PROGRESS';
    public const STATUS_CLOSED = 'CLOSED';
    public const STATUS_UNRESOLVED = 'UNRESOLVED';
    public const STATUS_HOLD = 'HOLD';

    public static function getStatuses()
    {
        return [
            self::STATUS_OPEN,
            self::STATUS_IN_PROGRESS,
            self::STATUS_CLOSED,
            self::STATUS_UNRESOLVED,
            self::STATUS_HOLD,
        ];
    }

    /**
     * Get the voter associated with this grievance
     */
    public function voter()
    {
        return $this->belongsTo(Voter::class, 'voter_id', 'voter_id_number');
    }

    /**
     * Get the ration card associated with this grievance
     */
    public function rationCard()
    {
        return $this->belongsTo(RationCard::class, 'ration_card_number', 'ration_card_number');
    }
}
