<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gifted_ration_cards', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('gift_id');
            $table->string('ration_card_number');
            $table->boolean('is_deleted')->default(false);
            $table->timestamps();
            
            // Foreign key constraints
            $table->foreign('gift_id')->references('id')->on('gifts')->onDelete('cascade');
            
            // Ensure unique combination of gift_id and ration_card_number (for non-deleted records)
            $table->unique(['gift_id', 'ration_card_number', 'is_deleted'], 'unique_gift_ration_card');
            
            // Index for performance
            $table->index(['gift_id', 'is_deleted']);
            $table->index(['ration_card_number', 'is_deleted']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gifted_ration_cards');
    }
};
