<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Cross-Origin Resource Sharing (CORS) Configuration
    |--------------------------------------------------------------------------
    |
    | Here you may configure your settings for cross-origin resource sharing
    | or "CORS". This determines what cross-origin operations may execute
    | in web browsers. You are free to adjust these settings as needed.
    |
    | To learn more: https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS
    |
    */

    'paths' => ['api/*', 'sanctum/csrf-cookie'],

    'allowed_methods' => ['*'],

    'allowed_origins' => config('environment.' . env('APP_ENV', 'development') . '.cors_origins', ['*']),

    'allowed_origins_patterns' => env('APP_ENV') === 'development'
        ? [
            // Allow localhost and common dev ports
            '/^https?:\\/\\/(localhost|127\\.0\\.0\\.1)(?::\\d+)?$/',
            // Allow local network (10.x.x.x, 172.16-31.x.x, 192.168.x.x) with any port
            '/^https?:\\/\\/(10\\.\\d+\\.\\d+\\.\\d+|192\\.168\\.\\d+\\.\\d+|172\\\.(1[6-9]|2\\d|3[01])\\.\\d+\\.\\d+)(?::\\d+)?$/',
        ]
        : [],

    'allowed_headers' => ['*'],

    'exposed_headers' => [],

    'max_age' => 0,

    'supports_credentials' => env('CORS_SUPPORTS_CREDENTIALS', false),

];
