<?php

namespace App\Repositories;

use App\Models\RationCard;
use App\Models\Voter;

class RationCardRepository
{
    public function create(array $data)
    {
        return RationCard::create($data);
    }

    public function getById($id)
    {
        return RationCard::find($id);
    }

    public function getByIdWithVoters($id)
    {
        return RationCard::with(['voters' => function($query) {
            $query->where('is_deleted', false);
        }])->where('is_deleted', false)->find($id);
    }

    public function getAll()
    {
        return RationCard::where('is_deleted', false)->get();
    }
    public function getByRationCardNumber($number)
    {
        return RationCard::where('ration_card_number', $number)
            ->where('is_deleted', false)
            ->first();
    }
    public function getByVoterId($voterId)
    {
        return Voter::where('voter_id_number', $voterId) ->where('is_deleted', false)->first();
    }
    public function getByAnyValue($value)
    {
        return Voter::where('is_deleted', false)
            ->where(function($query) use ($value) {
                $query->where('voter_id_number', $value)
                    ->orWhere('name', 'like', "%{$value}%")
                    ->orWhere('aadhar_number', $value)
                    ->orWhere('mobile_number', $value);
            })
            ->first();
    }
    public function update($id, array $data)
    {
        $rationCard = RationCard::find($id);

        if ($rationCard) {
            $rationCard->update($data);
            return $rationCard;
        }

        return null; // If the ration card does not exist
    }
    // In your RationCardService
    public function getPaginatedRationCards($perPage = 10)
    {
        return RationCard::where('is_deleted', false)->paginate($perPage); // Adjust the $perPage value as needed
    }

    // Method to get the ration card count
    public function getRationCardCount()
    {
        return RationCard::where('is_deleted', 0)->count();
    }
  // Method to get the voter count
    public function getVoterCount()
    {
        return Voter::where('is_deleted', 0)->count();
    }

    /**
     * Get the RationCard model for chunked processing
     * Used for large dataset operations
     */
    public function getModel()
    {
        return new RationCard();
    }

    /**
     * Get ration cards in chunks for memory-efficient processing
     */
    public function getInChunks($chunkSize = 1000, $callback = null)
    {
        return RationCard::with(['voters' => function ($query) {
            $query->where('is_head', true)->where('is_deleted', false);
        }])->chunk($chunkSize, $callback);
    }

    /**
     * Get total count for progress tracking
     */
    public function getTotalCount()
    {
        return RationCard::count();
    }

// Repository: Delete Ration Card by Number
public function deleteByRationCardNumber($rationCardNumber)
{
    $rationCard = RationCard::where('ration_card_number', $rationCardNumber)->first();
    if ($rationCard) {
        // Soft delete (if applicable)
        $rationCard->delete();
        return true;
    }
    return false;
}




}
