<?php

namespace App\Repositories;

use App\Models\Booth;

class BoothRepository
{

 
    // Create Booth
    public function create(array $data)
    {
        return Booth::create($data);
    }

    // Get Booth by booth_number
    public function getByBoothNumber($boothNumber)
    {
        return Booth::where('booth_number', $boothNumber)->first();
    }

    // Get all Booths
    public function getAll()
    {
        return Booth::where('is_deleted', 0)->orderBy('booth_number')->get();
    }

    // Get count of all Booths
    public function getBoothCount()
    {
        return Booth::where('is_deleted', 0)->count();
    }

    // Get Booth by ID
    public function getById($boothId)
    {
        return Booth::where('id', $boothId)->where('is_deleted', 0)->first();
    }


    // public function update($boothNumber, array $data)
    // {
    //     // First, check if the booth with the new booth_number already exists (if it's being updated to a new number)
    //     if (isset($data['booth_number'])) {
    //         $existingBooth = Booth::where('booth_number', $data['booth_number'])->first();

    //         // If a booth exists with the same booth number (but it's not the booth we are updating), return an error
    //         if ($existingBooth && $existingBooth->booth_number !== $boothNumber) {
    //             return null; // Or you can throw an exception or return an error message here
    //         }
    //     }

    //     // Fetch the booth based on the provided booth number
    //     $booth = Booth::where('booth_number', $boothNumber)->first();

    //     if ($booth) {
    //         // Update the booth with the new data
    //         $booth->update($data);
    //         return $booth;
    //     }

    //     // If the booth does not exist, return null or handle it differently (e.g., throw an exception)
    //     return null;
    // }

// public function update($boothNumber, array $data)
// {
//     // Fetch the booth by booth_number
//     $booth = Booth::where('booth_number', $boothNumber)->first();

//     if (!$booth) {
//         // If the booth does not exist
//         return null; // Booth not found
//     }

//     // Check if the booth_number in the data is different and exists
//     if (isset($data['booth_number']) && $data['booth_number'] !== $boothNumber) {
//         $existingBooth = Booth::where('booth_number', $data['booth_number'])->first();
//         if ($existingBooth) {
//             // Return error if the booth number already exists
//             return null; // Or throw an error, return a response, etc.
//         }
//     }

//     // Update the booth with new data
//     $booth->update($data);
//     return $booth;
// }


// public function update($boothNumber, array $data)
// {
//     // Fetch the booth by booth_number (current booth)
//     $booth = Booth::where('booth_number', $boothNumber)->first();

//     if (!$booth) {
//         // If the booth does not exist (for example, B003)
//         return null; // Booth not found, so can't update
//     }

//     // Check if the booth_number in the data is different (i.e., updating to a new number)
//     if (isset($data['booth_number']) && $data['booth_number'] !== $boothNumber) {
//         $existingBooth = Booth::where('booth_number', $data['booth_number'])->first();
        
//         if ($existingBooth) {
//             // If the booth number already exists in the DB (e.g., B007 already exists)
//             return null; // Or return a conflict response
//         }
//     }

//     // Proceed with updating the booth
//     $booth->update($data); // Update with new data (including new booth_number if applicable)
//     return $booth; // Return the updated booth
// }

public function update($boothId, array $data)
{
    // Find the booth by its unique ID
    $booth = Booth::find($boothId);

    if (!$booth) {
        // If the booth with the given ID doesn't exist
        return null; // Booth not found, so return null
    }

    // If the booth_number is being updated, check for conflicts with existing booth_numbers
    if (isset($data['booth_number']) && $data['booth_number'] !== $booth->booth_number) {
        // Check if the new booth_number already exists in the database
        $existingBooth = Booth::where('booth_number', $data['booth_number'])->first();
        
        if ($existingBooth) {
            // If the booth number already exists, return a conflict (409 error or similar)
            return null; // Or return a conflict response, e.g., 409 Conflict
        }
    }

    // Update the booth with the new data
    $booth->update($data);

    return $booth; // Return the updated booth
}




    // Soft delete
    public function delete($boothId)
    {
        $booth = Booth::where('id', $boothId)->first();

        if ($booth && !$booth->is_deleted) {
            $booth->is_deleted = true;
            return $booth->save(); // returns true if updated
        }

        return false; // Booth not found or already deleted
    }
}
