<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Street extends Model
{
    use HasFactory;

    protected $fillable = ['street_name', 'booth_id', 'is_deleted'];
    
    /**
     * Get the booth that owns the street
     * booth_id can be nullable in new save order
     */
    public function booth()
    {
        return $this->belongsTo(Booth::class, 'booth_id', 'id');
    }
}
