<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Booth extends Model
{
    use HasFactory;

  // Define the table name (optional if it matches the plural form)
    protected $table = 'booths';
    
    // Define the fillable attributes
    protected $fillable = ['booth_number', 'booth_address', 'streets', 'ward_no', 'h1', 'h2'];

    // Define the casts for JSON columns
    protected $casts = [
        'streets' => 'array',
    ];

   // Define the relationship: A booth has many voters
    public function voters()
    {
        return $this->hasMany(Voter::class, 'booth_number', 'booth_number');
    }
    
    // Streets are stored as array of street IDs in `streets` column
    // Provide a convenience accessor to resolve models when needed
    public function getStreetModelsAttribute()
    {
        $ids = is_array($this->streets) ? $this->streets : [];
        return Street::whereIn('id', $ids)->get();
    }
}
