<?php

namespace App\Http\Controllers;

use App\Constants\Constants;
use App\ResponseHandler\Response;
use App\Security\DecryptUtils;
use Illuminate\Http\Request;
use App\Services\AdminService;
use Exception;
use Illuminate\Http\Response as LaravelResponse;
use PHPMailer\PHPMailer\PHPMailer;

class AdminController extends Controller
{

    protected $adminService;

    protected $response;

    public function __construct(AdminService $adminService, Response $response)
    {
        $this->adminService = $adminService;
        $this->response = $response;
    }

    public function createAdmin(Request $request)
    {
        $data = $request->getContent();

        if (empty($data)) {
            return $this->response->respondWithError('Request data is empty');
        }

        $decryptedData = DecryptUtils::decryptRequestData($data);

        if ($decryptedData == null || ! is_array($decryptedData)) {
            return $this->response->respondWithError('Request data is empty');
        }

        return $this->adminService->createAdmin($decryptedData);
    }

    public function loginAdminUser(Request $request)
    {
        $data = $request->getContent();

        if (empty($data)) {
            return $this->response->respondWithError('Request data is empty');
        }

        $decryptedData = DecryptUtils::decryptRequestData($data);

        if ($decryptedData == null || ! is_array($decryptedData)) {
            return $this->response->respondWithError('Request data is empty');
        }

        if (!isset($decryptedData['username'])) {
            return $this->response->respondWithError('Please enter the Username');
        }

        if (!isset($decryptedData['password'])) {
            return $this->response->respondWithError('Please enter the password');
        }

        return $this->adminService->loginAdmin($decryptedData);
    }

    public function getAdminById(Request $request)
    {
        $id = $request->route('id');

        if (empty($id)) {
            return $this->response->respondWithError('Request data is empty');
        }

        return $this->adminService->getAdminById($id);
    }

    public function getAllAdmin()
    {
        return $this->adminService->getAllAdmin();
    }

    public function getAllDeletedAdmin()
    {
        return $this->adminService->getAllDeletedAdmin();
    }

    public function deleteAdminById(Request $request)
    {
        $id = $request->route('id');
        return $this->adminService->deleteAdminById($id);
    }

    // public function sendMail()
    // {
    //     return $this->adminService->sendMail();
    // }

    // public function getAllBookings(Request $request)
    // {
    //     $data = $request->getContent();

    //     if (empty($data)) {
    //         return $this->response->respondWithError('Request data is empty');
    //     }

    //     $decryptedData = DecryptUtils::decryptRequestData($data);

    //     if ($decryptedData == null || ! is_array($decryptedData)) {
    //         return $this->response->respondWithError('Request data is empty');
    //     }

    //     return $this->adminService->getAllBookings($decryptedData);
    // }

    // public function getBookingDetails(Request $request)
    // {
    //     $id = $request->route('id');

    //     return $this->adminService->getBookingDetails($id);
    // }

    // public function getAllTransactions(Request $request)
    // {
    //     $data = $request->getContent();

    //     if (empty($data)) {
    //         return $this->response->respondWithError('Request data is empty');
    //     }

    //     $decryptedData = DecryptUtils::decryptRequestData($data);

    //     if ($decryptedData == null || ! is_array($decryptedData)) {
    //         return $this->response->respondWithError('Request data is empty');
    //     }

    //     return $this->adminService->getAllTransactions($decryptedData);
    // }

    // public function getTransactionDetails(Request $request)
    // {
    //     $id = $request->route('id');

    //     return $this->adminService->getTransactionDetails($id);
    // }

    public function updateAdminById(Request $request)
    {
        $id = $request->route('id');

        $data = $request->getContent();

        if (empty($data)) {
            return $this->response->respondWithError('Request data is empty');
        }

        $decryptedData = DecryptUtils::decryptRequestData($data);

        if ($decryptedData == null || ! is_array($decryptedData)) {
            return $this->response->respondWithError('Request data is empty');
        }

        return $this->adminService->updateAdminById($id, $decryptedData);
    }

    public function changeAdminPassword(Request $request)
    {
        $data = $request->getContent();

        if (empty($data)) {
            return $this->response->respondWithError('Request data is empty');
        }

        $decryptedData = DecryptUtils::decryptRequestData($data);

        if ($decryptedData == null || ! is_array($decryptedData)) {
            return $this->response->respondWithError('Request data is empty');
        }

        return $this->adminService->changeAdminPassword($decryptedData);
    }

    // public function generateExcelForBookings(Request $request)
    // {
    //     $data = $request->getContent();

    //     if (empty($data)) {
    //         return $this->response->respondWithError('Request data is empty');
    //     }

    //     $decryptedData = DecryptUtils::decryptRequestData($data);

    //     if ($decryptedData == null || ! is_array($decryptedData)) {
    //         return $this->response->respondWithError('Request data is empty');
    //     }

    //     return $this->adminService->generateExcelForBookings($decryptedData);
    // }


    // public function getAllUsers(Request $request)
    // {

    //     $data = $request->getContent();

    //     if (empty($data)) {
    //         return $this->response->respondWithError('Request data is empty');
    //     }

    //     $decryptedData = DecryptUtils::decryptRequestData($data);

    //     if ($decryptedData == null || ! is_array($decryptedData)) {
    //         return $this->response->respondWithError('Request data is empty');
    //     }

    //     return $this->adminService->getAllUsers($decryptedData);
    // }


    // public function getAllRegisteredMembers(Request $request)
    // {

    //     $data = $request->getContent();

    //     if (empty($data)) {
    //         return $this->response->respondWithError('Request data is empty');
    //     }

    //     $decryptedData = DecryptUtils::decryptRequestData($data);

    //     if ($decryptedData == null || ! is_array($decryptedData)) {
    //         return $this->response->respondWithError('Request data is empty');
    //     }

    //     return $this->adminService->getAllRegisteredMembers($decryptedData);
    // }

    // public function downloadInvoice(Request $request)
    // {
    //     return $this->adminService->downloadInvoice();
    // }

    // public function generateMembershipInvoice(Request $request)
    // {
    //     return $this->adminService->generateMembershipInvoice();
    // }

    //  public function generateBookingInvoice(Request $request)
    // {
    //     return $this->adminService->generateBookingInvoice();
    // }
    
    // public function resendInvoice(Request $request)
    // {
    //     $data = $request->getContent();

    //     if (empty($data)) {
    //         return $this->response->respondWithError('Request data is empty');
    //     }

    //     $decryptedData = DecryptUtils::decryptRequestData($data);

    //     if ($decryptedData == null || ! is_array($decryptedData)) {
    //         return $this->response->respondWithError('Request data is empty');
    //     }

    //     return $this->adminService->resendInvoiceFile($decryptedData);
    // }
}
